define(['angular', 'app'], function (angular, app) {
	"use strict";
	app.service('localResourceDirectoryService', function ($http, $q) {
		var directory = {},
			isReady;

		directory.fetch = function () {
			if (isReady) {
				return isReady.promise;
			}

			isReady = $q.defer();
			$http.get("resources.json").then(function(response) {
				response.data.link.forEach(function (link) {
					directory[link.title] = link.href;
				});
				isReady.resolve(directory);
			}, function (error) {
				isReady.reject(error);
				isReady = null;
			});

			return isReady.promise;
		};

		return directory;
	});
});